﻿<%@ Page Language="c#" AutoEventWireup="false" CodePage="1200" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Handel" %>
<%@ Import Namespace="Soneta.CRM" %>
<%@ Import Namespace="Soneta.Towary" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Tools" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>Dokumenty wg towarów</title>

    <script runat="server">
		
        static DokumentyParams dparametry;

        [Context(Required = false)]
        public static DokumentyParams DParametry {
            get { return dparametry; }
            set { dparametry = value; }
        }
        
        public class ParametryContext : ContextBase
        {
            public ParametryContext(Context cx)
                : base(cx)
            {
            }

            bool _ignorujZaliczkowe = true;

            [Priority(10)]
            public bool IgnorujZaliczkowe
            {
                get { return _ignorujZaliczkowe; }
                set { _ignorujZaliczkowe = value; OnChanged(EventArgs.Empty); }
            }
        }

        ParametryContext parametry;

        [Context]
        public ParametryContext Parametry
        {
            get { return parametry; }
            set { parametry = value; }
        }

        public class Total : IComparable
        {
            readonly Towar towar;
            decimal netto = 0;
            decimal vat = 0;
            decimal brutto = 0;
            int liczba = 0;
            Quantity ilość = Quantity.Zero;

            public Total(Towar towar)
            {
                this.towar = towar;
            }
            
            SumaPozycjiWorker spw = new SumaPozycjiWorker();
            
            public void Add(PozycjaDokHandlowego poz)
            {                
                spw.Pozycja = poz;
                netto += spw.Netto;
                vat += spw.Vat;
                brutto += spw.Brutto;
                ilość += poz.ZmianaMagazynu.Ilość;
                ++liczba;
            }
            public Towar Towar
            {
                get { return towar; }
            }
            public int Liczba
            {
                get { return liczba; }
            }
            public Quantity Ilość
            {
                get { return ilość; }
            }
            public decimal Netto
            {
                get { return netto; }
            }
            public decimal Brutto
            {
                get { return brutto; }
            }
            public decimal VAT
            {
                get { return vat; }
            }
            public int CompareTo(object obj)
            {
                Total t = (Total)obj;
                return towar.Kod.CompareTo(t.Towar.Kod);
            }
        }

        FiltrStanu filtrStanu;

        [Context]
        public FiltrStanu FiltrStanu
        {
            get { return filtrStanu; }
            set { filtrStanu = value; }
        }
        
        Kontrahent kontrahent;
        
        [Context(Required=false)]
        public Kontrahent KontrahentCx
        {
            get { return kontrahent; }
            set { kontrahent = value; }
        }

        void OnContextLoad(Object sender, EventArgs args)
        {

            if (DParametry != null) {
                string partia = CaptionAttribute.EnumToString(DParametry.FiltrTypuPartii);
                string typ = CaptionAttribute.EnumToString(DParametry.FiltrTypu);
                string linia = "|Partia: <STRONG>" + partia + "</STRONG>, Typ: <STRONG>" + typ + "</STRONG>";
                ReportHeader.Title += linia;
            }

            ReportHeader.Title = ReportHeader.Title.Insert(
                ReportHeader.Title.IndexOf('|'),
                "|" + DokHandlowe.GetInformacjaStanu(FiltrStanu));
            
            if (KontrahentCx != null)
                ReportHeader.Title += "|Kontrahent: <strong>" + HttpUtility.HtmlEncode(KontrahentCx.ToString()) + "</strong>";
            
            Row[] rows = (Row[])dc[typeof(Row[])];
            Hashtable result = new Hashtable();
            int licznik = 0;
            foreach (DokumentHandlowy dokument in rows)
            {
                if (++licznik % 30 == 0)
                    System.Diagnostics.Trace.Write(licznik * 100 / rows.Length, "Progress");
                if (dokument.Anulowany) continue;
                if (dokument.Definicja.DuplikatWartosci) continue;
                if (Parametry.IgnorujZaliczkowe && dokument.Definicja.EdycjaWartosci == EdycjaWartosciDokumentu.PozwalajNaMniejsząKwotę) continue;
                foreach (PozycjaDokHandlowego pozycja in dokument.Pozycje)
                {

                    Total t = (Total)result[pozycja.Towar];
                    if (t == null)
                    {
                        t = new Total(pozycja.Towar);
                        result.Add(pozycja.Towar, t);
                    }
                    t.Add(pozycja);
                }
            }

            ArrayList lista = new ArrayList(result.Values);
            lista.Sort();
            Grid.DataSource = lista;
        }

    </script>

    <meta content="C#" name="CODE_LANGUAGE" />
    <meta content="JavaScript" name="vs_defaultClientScript" />
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
</head>
<body>
    <form method="post" runat="server">
        <ea:DataContext ID="dc" runat="server" OnContextLoad="OnContextLoad"></ea:DataContext>
        <eb:ReportHeader ID="ReportHeader" Title="Dokumenty wg towarów|</STRONG>Okres:<STRONG> {2}|</STRONG>Magazyn:<STRONG> {3}</STRONG>"
            runat="server" DataMember3="Magazyn" DataMember2="FromTo"></eb:ReportHeader>
        <ea:Grid ID="Grid" runat="server" RowTypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel">
            <Columns>
                <ea:GridColumn Caption="LP." DataMember="#" Align="Right" Width="4" runat="server"
                    EncodeHTML="True">
                </ea:GridColumn>
                <ea:GridColumn EncodeHTML="True" DataMember="Towar.Kod" Width="17" Caption="Towar~Kod"
                    runat="server">
                </ea:GridColumn>
                <ea:GridColumn EncodeHTML="True" DataMember="Towar.Nazwa" Caption="Towar~Nazwa" runat="server">
                </ea:GridColumn>
                <ea:GridColumn DataMember="Ilość" Align="Right" Width="12" runat="server" EncodeHTML="True">
                </ea:GridColumn>
                <ea:GridColumn DataMember="Netto" Align="Right" Width="13" Format="{0:n}" Total="Sum"
                    Caption="Wartość pozycji~Netto" runat="server" EncodeHTML="True">
                </ea:GridColumn>
                <ea:GridColumn DataMember="VAT" Align="Right" Width="13" Format="{0:n}" Total="Sum"
                    Caption="Wartość pozycji~VAT" runat="server" EncodeHTML="True">
                </ea:GridColumn>
                <ea:GridColumn DataMember="Brutto" Align="Right" Width="13" Format="{0:n}" Total="Sum"
                    Caption="Wartość pozycji~Brutto" runat="server" EncodeHTML="True">
                </ea:GridColumn>
                <ea:GridColumn DataMember="Liczba" Align="Right" Width="8" runat="server" Caption="Liczba Pozycji"
                    EncodeHTML="True">
                </ea:GridColumn>
            </Columns>
        </ea:Grid>
        <eb:ReportFooter ID="ReportFooter" runat="server" TheEnd="False">
        </eb:ReportFooter>
    </form>
</body>
</html>

